# delimit ; 
clear all; 
set mem 300m;	
set more 1 ;  
drop _all;
program drop _all;
capture log close;
local path_location "D:\";
*local path_location "C:\";
*local path_location "C:\Users\ebf26\";
log using `path_location'Dropbox\hrs\wealthcouples\assetprof_growth.log, replace; 
*log using C:\Dropbox\hrs\wealthcouples\assetprof_growth.log, replace; 

*log using c:\research\hrs\wealthcouples\assetprof.log, replace; 
*use E:\Dropbox\hrs\wealthcouples\dataprep2_4states;
*use c:\users\eric\dropbox\hrs\wealthcouples\dataprep2_4states;
cls;

use "`path_location'\Dropbox\hrs\wealthcouples\dataprep2_4states.dta";
gen nevermarried_divorced =0;
replace nevermarried_divorced=1 if manmarstat==5|manmarstat==8| lmanmarstat==5|lmanmarstat==8| womanmarstat==5|womanmarstat==8| lwomanmarstat==5|lwomanmarstat==8;

sum nevermarried_divorced;

sum assets, det;
drop if assets>r(p99);
replace assets=1000 if assets<1000 & assets~=.;

replace assets=. if wave==2;

sort HHID wave;

replace child=. if children==.;
replace children=children[_n-1]  if HHID==HHID[_n-1] & children==.;
replace children=0 if children ==.;
replace child = 0 if children==0;
replace child = 1 if children>0 & children~=.;

gen homeowner=0;
replace homeowner=1 if house>0 & house~=.;
replace homeowner=homeowner[_n-1] if HHID==HHID[_n-1];

gen initwealth=assets;
replace initwealth=initwealth[_n-1] if HHID==HHID[_n-1];
*drop if wave<4;


gen manwomanINC=manINC/(manINC+womanINC);
replace manwomanINC=0.7 if manwomanINC==.;

sum manwomanINC if hhstatus==3, detail;




sum home*;



gen log_assets=ln(assets);
* this creates a "short difference";
gen Delta_assets=assets[_n+1]-assets if HHID[_n+1]==HHID & (wave[_n+1]==1+wave );
replace Delta_assets=assets[_n+1]-assets if HHID[_n+1]==HHID & (wave[_n+1]==2+wave|wave[_n+1]==3+wave);
*|wave[_n+1]==3+wave|wave[_n+1]==4+wave|wave[_n+1]==5+wave|wave[_n+1]==6+wave);
* this creates a long difference;
gen lead1assets=assets[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2assets=lead1assets[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3assets=lead2assets[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4assets=lead3assets[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5assets=lead4assets[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);


gen lead1hhstatus=hhstatus[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2hhstatus=lead1hhstatus[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3hhstatus=lead2hhstatus[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4hhstatus=lead3hhstatus[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5hhstatus=lead4hhstatus[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);



gen single_died=(hhdead[_n+1]==1 & (hhstatus==1|hhstatus==2));
gen couple_died=(hhdead[_n+1]==1 & hhstatus==3);
gen single_diedPI=single_died*pi_perc;
gen couple_diedPI=couple_died*pi_perc;
gen single_mPI=single_m*pi_perc;
gen single_wPI=single_w*pi_perc;
gen single_mage=single_m*hhage;
gen single_wage=single_w*hhage;

* health indicators for each member;
gen manbadheal=(manheal==2);
gen mannursheal=(manheal==1);
gen womanbadheal=(womanheal==2);
gen womannursheal=(womanheal==1);

gen womanbadhealadl=(womanhealadl==3);
gen womanadlhealadl=(womanhealadl==2);
gen manbadhealadl=(manhealadl==3);
gen manadlhealadl=(manhealadl==2);


gen lead1manbadheal=manbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2manbadheal=lead1manbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3manbadheal=lead2manbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4manbadheal=lead3manbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5manbadheal=lead4manbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);

gen lead1womanbadheal=womanbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2womanbadheal=lead1womanbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3womanbadheal=lead2womanbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4womanbadheal=lead3womanbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5womanbadheal=lead4womanbadheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);


gen lead1mannursheal=mannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2mannursheal=lead1mannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3mannursheal=lead2mannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4mannursheal=lead3mannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5mannursheal=lead4mannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);

gen lead1womannursheal=womannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead2womannursheal=lead1womannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead3womannursheal=lead2womannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead4womannursheal=lead3womannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);
gen lead5womannursheal=lead4womannursheal[_n+1] if HHID[_n+1]==HHID & (wave[_n+1]==1+wave| wave[_n+1]==2+wave|wave[_n+1]==3+wave);


local gap=1;

replace Delta_assets=lead`gap'assets-assets;
gen leadhhstatus=lead`gap'hhstatus;

gen leadmanbadheal=lead`gap'manbadheal;
gen leadwomanbadheal=lead`gap'womanbadheal;
gen leadmannursheal=lead`gap'mannursheal;
gen leadwomannursheal=lead`gap'womannursheal;

* homeowner;
reg Delta_assets homeowner;
sqreg Delta_assets homeowner, q(0.25 0.5 0.75);;


* someone dies;********;
reg Delta_assets if leadhhstatus<hhstatus & hhstatus==3;
sqreg Delta_assets if leadhhstatus<hhstatus & hhstatus==3, q(0.25 0.5 0.75);;

*bomb;


* kids;
reg Delta_assets child;
sqreg Delta_assets child, q(0.25 0.5 0.75);;
*reg Delta_log_assets child; 



* kids, holding household structure constant;
reg Delta_assets child if leadhhstatus==hhstatus;
sqreg Delta_assets child if leadhhstatus==hhstatus, q(0.25 0.5 0.75);;;
*reg Delta_log_assets child if hhstatus[_n+1]==hhstatus;; 

* kids, holding household structure constant;
reg Delta_assets child pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;
sqreg Delta_assets child  pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus, q(0.25 0.5 0.75);;;
*reg Delta_log_assets child if hhstatus[_n+1]==hhstatus;; 

* by household status;
reg Delta_assets single_m single_w if leadhhstatus==hhstatus;
sqreg Delta_assets single_m single_w if leadhhstatus==hhstatus, q(0.25 0.5 0.75);;;
*reg Delta_log_assets single_m single_w if hhstatus[_n+1]==hhstatus;; 


* by household status;
reg Delta_assets single_m single_w nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets single_m single_w nevermarried_divorced if leadhhstatus==hhstatus , q(0.25 0.5 0.75);;;
*reg Delta_log_assets single_m single_w if hhstatus[_n+1]==hhstatus;; 


* by household status, controlling for PI age;
reg Delta_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;
sqreg Delta_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus , q(0.25 0.5 0.75);
*sqreg Delta_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage  , q(0.25 0.5 0.75);
*reg Delta_log_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if hhstatus[_n+1]==hhstatus;; 



* by health status;
reg Delta_assets  manbadheal mannursheal womanbadheal womannursheal single_m single_w if leadhhstatus==hhstatus;
qreg Delta_assets  manbadheal mannursheal womanbadheal womannursheal single_m single_w if leadhhstatus==hhstatus;;
*reg Delta_log_assets single_m single_w if hhstatus[_n+1]==hhstatus;; 

* by household status, controlling for PI age;
reg Delta_assets manbadheal mannursheal womanbadheal womannursheal single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;
qreg Delta_assets manbadheal mannursheal womanbadheal womannursheal single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;;
*reg Delta_log_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if hhstatus[_n+1]==hhstatus;; 


* by health status including ADL states;
reg Delta_assets  mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl single_m single_w if leadhhstatus==hhstatus;
qreg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w if leadhhstatus==hhstatus;;
*reg Delta_log_assets single_m single_w if hhstatus[_n+1]==hhstatus;; 

* by household status including ADL states, controlling for PI age;
reg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus, q(0.25 0.5 0.75);
*reg Delta_log_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if hhstatus[_n+1]==hhstatus;; 

* by household status including ADL states, controlling for PI age;
reg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc pi_perc2 hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc pi_perc2 hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

* final reported approach--same as above, but dropping PI-squared;
reg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc  hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m single_w pi_perc hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);


* final reported approach--same as above, but dropping PI-squared, using old health measures;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  single_m single_w pi_perc  hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  single_m single_w pi_perc hhage hhage2 PIage child nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

********** OLD

* final reported approach--same as above, but dropping PI-squared, old health measures, and also leads;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  single_m single_w pi_perc  hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal single_m single_w pi_perc hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

* this adds initial homeownership;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  single_m single_w pi_perc  hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal single_m single_w pi_perc hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

* this adds ratio of man's income to total;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  single_m single_w pi_perc  hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal single_m single_w pi_perc hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);


gen death_dummy=(leadhhstatus<hhstatus) if leadhhstatus!=. & hhstatus!=.;
* this adds ratio of man's income to total;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  single_m single_w pi_perc  hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced death_dummy if leadhhstatus!=0 & leadhhstatus!=.;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal single_m single_w pi_perc hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced death_dummy if leadhhstatus!=0 & leadhhstatus!=., q(0.25 0.5 0.75);



*********************WE LIKE THIS ONE *******************************************************************;
* final reported approach--same as above, but dropping PI-squared, old health measures, and also leads;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  couple pi_perc  hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal couple pi_perc hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

* this adds initial homeownership;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  couple pi_perc  hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal couple pi_perc hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);

* this adds ratio of man's income to total;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  couple pi_perc  hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal couple pi_perc hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);


* this adds ratio of man's income to total;
reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal couple pi_perc  hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced death_dummy if leadhhstatus!=0 & leadhhstatus!=.;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal couple pi_perc hhage hhage2 PIage child children homeowner manwomanINC nevermarried_divorced death_dummy if leadhhstatus!=0 & leadhhstatus!=., q(0.25 0.5 0.75);

bomb;



reg Delta_assets mannursheal womannursheal womanbadheal  manbadheal  leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal  single_m single_w pi_perc  hhage hhage2 PIage child children homeowner initwealth nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets mannursheal womannursheal womanbadheal  manbadheal leadmannursheal leadwomannursheal leadwomanbadheal  leadmanbadheal single_m single_w pi_perc hhage hhage2 PIage child children homeowner  initwealth nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);



* same as above, but no health measures;
reg Delta_assets  single_m single_w pi_perc  hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets single_m single_w pi_perc hhage hhage2 PIage child children nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);



* same as above, but no health measures;
reg Delta_assets  single_m single_w pi_perc  hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus;
sqreg Delta_assets single_m single_w pi_perc hhage hhage2 PIage child children homeowner nevermarried_divorced if leadhhstatus==hhstatus, q(0.25 0.5 0.75);



* by household status including ADL states, controlling for PI age, interaction of single and age;
*reg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m *single_w single_mage single_wage pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;
*qreg Delta_assets mannursheal womannursheal womanbadhealadl  womanadlhealadl manbadhealadl  manadlhealadl  single_m *single_w single_mage single_wage pi_perc pi_perc2 hhage hhage2 PIage if leadhhstatus==hhstatus;;
*reg Delta_log_assets single_m single_w pi_perc pi_perc2 hhage hhage2 PIage if hhstatus[_n+1]==hhstatus;; 



*drop _all;
program drop _all;
log close;


